'*************************************************************
' 
' ADOBE SYSTEMS INCORPORATED 
' Copyright 2005-2010 Adobe Systems Incorporated 
' All Rights Reserved 

' NOTICE:  Adobe permits you to use, modify, and 
' distribute this file in accordance with the terms
' of the Adobe license agreement accompanying it.  
' If you have received this file from a source 
' other than Adobe, then your use, modification,
' or distribution of it requires the prior 
' written permission of Adobe. 
' 
'*************************************************************

' Calendar.vbs

' DESCRIPTION

' This example shows how you can use a template document, which 
' defines a standardized graphical layout for a calendar, to 
' display dynamically generated current month and year data. 
' This uses a combination of the powerful Visual Basic programming 
' feature set and Illustrators rich graphics and text 
' manipulation capabilities.
' 
'*************************************************************


Set appRef = CreateObject("Illustrator.Application")
Set fileSystemObject = CreateObject("Scripting.FileSystemObject")

' Creating a folder browser in VBScript can be a problem (relying on either Windows API calls
' or use of ActiveX controls which may not be present on a given system). Instead, use
' Illustrator's built-in JavaScript to display a file browser. DoJavaScript can return a value,
' in this example it's the platform specific full path to the chosen template file.

doJavaScript = "var templateFile = File.openDialog(""Select CalendarTemplate.ai file:""); if (templateFile) filePath = templateFile.fsName;"
myFilePath = appRef.DoJavaScript(doJavaScript)

If (fileSystemObject.FileExists(myFilePath)) Then
	' Open the template file.
	appRef.Open(myFilePath)
	Set templateRef = appRef.ActiveDocument

	' Determine the number of days in the current month

	daysInMonth = 31
	While (Not IsDate(CStr(Month(Date)) & "/" & CStr(daysInMonth) & "/" & CStr(Year(Date))))
		daysInMonth = daysInMonth - 1
	Wend

	' Determine what day of the week the first falls on using Monday as "week day 1"

	day1DayOfWeek = Weekday(DateValue(CStr(Month(Date)) & "/01/" & CStr(Year(Date))), vbMonday)
	daysHeader = Array("M", "T", "W", "T", "F", "S", "S")

	' Fill out a matrix of 6 rows (weeks) times 7 columns (week days) with the day
	' (a month can span up to 6 weeks)
	' value as a string in the correct offset given the position of day 1 in relation
	' to the first Monday of the month

	nRows = 6
	nCols = 7
	Dim calRows(6)
	dayCnt = 1
	For rowCnt = 1 To nRows
		calRows(rowCnt - 1) = Array("", "", "", "", "", "", "")
		For colCnt = 1 To nCols
			If (dayCnt > daysInMonth) Then
  				Exit For
			End If
			If (Not (rowCnt = 1 And colCnt < day1DayOfWeek)) Then
  				calRows(rowCnt - 1)(colCnt - 1) = CStr(dayCnt)
  				dayCnt = dayCnt + 1
			End If
		Next
	Next

	' Next, join the day strings with tab delimiters to assemble each
	' weeks paragraph text. Make the weekend values red.

	Set weekendColor = CreateObject("Illustrator.CMYKColor")
	weekendColor.Magenta = 100
	weekendColor.Yellow = 90

	For Each textArt In templateRef.TextFrames
		If (textArt.Contents = "#Name") Then
  			textArt.Contents = FormatDateTime(Date, 1 )
		Else
  			If (textArt.Contents = "#Days") Then
				' Assemble the header and numerical days and add to the text item
	    			sText = Join(daysHeader, vbTab)
    				For rowCnt = 1 To nRows
      				sText = sText & vbCrLf & Join(calRows(rowCnt - 1), vbTab)
    				Next
    				textArt.Contents = sText
				' colorize the weekend dates
				For Each lineRef In textArt.Lines
					If (lineRef.Words.Count >= 12) Then
	    					lineRef.Words(12).CharacterAttributes.FillColor = weekendColor
					End If
					If (lineRef.Words.Count >= 13) Then
	   					lineRef.Words(13).CharacterAttributes.FillColor = weekendColor
					End If
    				Next
			End If
		End If
	Next

	Set textArt = Nothing
	Set weekendColor = Nothing
End If

'' SIG '' Begin signature block
'' SIG '' MIIY1QYJKoZIhvcNAQcCoIIYxjCCGMICAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFLEdORfta3oY
'' SIG '' 7uUsNDm1PfrPhRsZoIITuzCCA+4wggNXoAMCAQICEH6T
'' SIG '' 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
'' SIG '' CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
'' SIG '' cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
'' SIG '' EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
'' SIG '' Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
'' SIG '' aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
'' SIG '' NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
'' SIG '' bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
'' SIG '' bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
'' SIG '' RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
'' SIG '' AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
'' SIG '' FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
'' SIG '' a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
'' SIG '' AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
'' SIG '' +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
'' SIG '' 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
'' SIG '' 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
'' SIG '' RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
'' SIG '' gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
'' SIG '' gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
'' SIG '' aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
'' SIG '' CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
'' SIG '' Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
'' SIG '' bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
'' SIG '' VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
'' SIG '' VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
'' SIG '' BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
'' SIG '' nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
'' SIG '' sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
'' SIG '' JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
'' SIG '' g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
'' SIG '' UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
'' SIG '' MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
'' SIG '' BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
'' SIG '' dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
'' SIG '' MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
'' SIG '' VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
'' SIG '' AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
'' SIG '' cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
'' SIG '' sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
'' SIG '' duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
'' SIG '' TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
'' SIG '' YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
'' SIG '' vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
'' SIG '' nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
'' SIG '' 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
'' SIG '' EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
'' SIG '' FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
'' SIG '' AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
'' SIG '' MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
'' SIG '' bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
'' SIG '' MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
'' SIG '' ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
'' SIG '' MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
'' SIG '' VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
'' SIG '' IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
'' SIG '' SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
'' SIG '' st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
'' SIG '' JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
'' SIG '' dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
'' SIG '' bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
'' SIG '' K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
'' SIG '' SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
'' SIG '' ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
'' SIG '' w7wc2AR1MIIFVjCCBD6gAwIBAgIQGRoyy3Wcl7jPrBGN
'' SIG '' 1RJ/STANBgkqhkiG9w0BAQsFADCByjELMAkGA1UEBhMC
'' SIG '' VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
'' SIG '' VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYD
'' SIG '' VQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAtIEZv
'' SIG '' ciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW
'' SIG '' ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENl
'' SIG '' cnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcNMTQw
'' SIG '' MzA0MDAwMDAwWhcNMjQwMzAzMjM1OTU5WjCBkTELMAkG
'' SIG '' A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
'' SIG '' cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
'' SIG '' ZXR3b3JrMUIwQAYDVQQDEzlTeW1hbnRlYyBDbGFzcyAz
'' SIG '' IEV4dGVuZGVkIFZhbGlkYXRpb24gQ29kZSBTaWduaW5n
'' SIG '' IENBIC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
'' SIG '' ggEKAoIBAQDQGALu7aKNCFhjDybX3SJ7iPbkx+w7Jhh4
'' SIG '' 08ekIFONg3ylP36lyCtH3w31ptnDHSWTYM983OoDLL54
'' SIG '' f1xIbacC2Un4oevrmmF8n8Am1twV2LgQfCC6XvQo9qjq
'' SIG '' p1x8xpyQkDQ8tiKs/roMOh7WXoS2W/CjgXB4io1GUnv8
'' SIG '' 20nzKRMRdE+NFrPC46AtxwMEnczDcuEODPsCjvEmF3tu
'' SIG '' rvi3M4umYUtF3/IlRMf3sJgjNtwoeQrom3KIqNjornt/
'' SIG '' CmRFpfBXkpp3BkUe65/oZvN6fZKBXwAtHrj2VhNaYg23
'' SIG '' R6GPcu+DXoLglJjhrKWthjfgp9O6sT5660Wo8cFEfeID
'' SIG '' AgMBAAGjggFtMIIBaTASBgNVHRMBAf8ECDAGAQH/AgEA
'' SIG '' MC8GA1UdHwQoMCYwJKAioCCGHmh0dHA6Ly9zLnN5bWNi
'' SIG '' LmNvbS9wY2EzLWc1LmNybDAWBgNVHSUBAf8EDDAKBggr
'' SIG '' BgEFBQcDAzAOBgNVHQ8BAf8EBAMCAQYwLgYIKwYBBQUH
'' SIG '' AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
'' SIG '' ZC5jb20wXwYDVR0gBFgwVjBUBgRVHSAAMEwwIwYIKwYB
'' SIG '' BQUHAgEWF2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUG
'' SIG '' CCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20v
'' SIG '' cnBhMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFTeW1h
'' SIG '' bnRlY1BLSS0xLTYyOTAdBgNVHQ4EFgQUFmbeSjTjUKcR
'' SIG '' hgOxbKnGrM1ZbpswHwYDVR0jBBgwFoAUf9Nlp8Ld7Lvw
'' SIG '' MAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQADggEBAD9b
'' SIG '' GfP6E9V1OCpa7p9aoEypHcXMlO7eFf71EG6kG6Vkg1QY
'' SIG '' WMQLKKGFw0505f+JfP7V7Ty6cZ9WAiaPFiqI/rCjJyLO
'' SIG '' S+I4jgCmOoZfneU+qN5kSUF0QSH9B8iEF9odZTCCyyZP
'' SIG '' OdYEJ6SBsUtJwyOLfgIyGCe3qwvzGHK2pO5nBm84pliN
'' SIG '' 4PF+XaRgxqjlUF/g6Lrij5lYtrWgqHbxovEciEFyflKX
'' SIG '' mwo2mY1Q9wHrPOfwImrlNYxjNooasdlnZl+XGu+oIJ3w
'' SIG '' L7psztmUhQDxWPF9yXwitQddAsbmC7+rk5P/JxiOMzZ+
'' SIG '' VzTxw68EwYTxVrPoh4M2+NMKMdxuLG0wggXEMIIErKAD
'' SIG '' AgECAhAeObM6nEaakCI61S77g784MA0GCSqGSIb3DQEB
'' SIG '' CwUAMIGRMQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3lt
'' SIG '' YW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5bWFu
'' SIG '' dGVjIFRydXN0IE5ldHdvcmsxQjBABgNVBAMTOVN5bWFu
'' SIG '' dGVjIENsYXNzIDMgRXh0ZW5kZWQgVmFsaWRhdGlvbiBD
'' SIG '' b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNTExMDYwMDAw
'' SIG '' MDBaFw0xNzEwMjgyMzU5NTlaMIIBDjETMBEGCysGAQQB
'' SIG '' gjc8AgEDEwJVUzEZMBcGCysGAQQBgjc8AgECFAhEZWxh
'' SIG '' d2FyZTEdMBsGA1UEDxMUUHJpdmF0ZSBPcmdhbml6YXRp
'' SIG '' b24xEDAOBgNVBAUTBzI3NDgxMjkxCzAJBgNVBAYTAlVT
'' SIG '' MRMwEQYDVQQIDApDYWxpZm9ybmlhMREwDwYDVQQHDAhT
'' SIG '' YW4gSm9zZTEjMCEGA1UECgwaQWRvYmUgU3lzdGVtcyBJ
'' SIG '' bmNvcnBvcmF0ZWQxLDAqBgNVBAsMI0lsbHVzdHJhdG9y
'' SIG '' LCBJbkRlc2lnbiwgSW5Db3B5LCBNdXNlMSMwIQYDVQQD
'' SIG '' FBpBZG9iZSBTeXN0ZW1zIEluY29ycG9yYXRlZDCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJpOMyAj
'' SIG '' 8r+7FuNs3MXed0OMajoJnoF4v8cV+9drUVII+pzb6yeV
'' SIG '' GdBTt8U03rk1a2V51gcTHAorQxs2plJIgafn/pqMzG7f
'' SIG '' 9FZui7WiMOuyif/0joytDGujeQd7xQ/23YYtZpQQ/ahz
'' SIG '' VI4Pzv44FVDGwHYfGxGaQ127Bqp5EhLX7zwFiGEPnP3V
'' SIG '' R4ZyQn2WQeA0a68KuhD6anNHize0XjSBFelrNhN4uYpk
'' SIG '' prXyGv8vKdq9a911iY/efPsRueUPYucYJCF/lBt3DaR4
'' SIG '' J/FeaSJeijyllNwAqu7XY7Jl9zB0duRLlRFpGJeCymhY
'' SIG '' 3wvU6039CHBnrYIXZ/ldAWUpz+MCAwEAAaOCAZYwggGS
'' SIG '' MC4GA1UdEQQnMCWgIwYIKwYBBQUHCAOgFzAVDBNVUy1E
'' SIG '' RUxBV0FSRS0yNzQ4MTI5MAkGA1UdEwQCMAAwKwYDVR0f
'' SIG '' BCQwIjAgoB6gHIYaaHR0cDovL3N3LnN5bWNiLmNvbS9z
'' SIG '' dy5jcmwwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwMwDgYD
'' SIG '' VR0PAQH/BAQDAgeAMGYGA1UdIARfMF0wWwYLYIZIAYb4
'' SIG '' RQEHFwYwTDAjBggrBgEFBQcCARYXaHR0cHM6Ly9kLnN5
'' SIG '' bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIwGQwXaHR0cHM6
'' SIG '' Ly9kLnN5bWNiLmNvbS9ycGEwHQYDVR0OBBYEFPsxU7iZ
'' SIG '' MQ82sRMZZ9wcUZpCtgBaMFgGCCsGAQUFBwEBBEwwSjAf
'' SIG '' BggrBgEFBQcwAYYTaHR0cDovL3N3LnN5bWNkLmNvbTAn
'' SIG '' BggrBgEFBQcwAoYbaHR0cDovL3N3MS5zeW1jYi5jb20v
'' SIG '' c3cuY3J0MB8GA1UdIwQYMBaAFBZm3ko041CnEYYDsWyp
'' SIG '' xqzNWW6bMA0GCSqGSIb3DQEBCwUAA4IBAQBQEAjwXAas
'' SIG '' FygBRU/4fmAgJdTZDZFT/Gri5Vi28b6iHzDnTKcr3QTJ
'' SIG '' 33Ql9LbIi2CjtnD1n0zyvIdjXDXFLcbeMoQQ9L5XuiRw
'' SIG '' kwUPpRrLYsNPQ8G3n7N/me223Sw4noAy0ErrUNZd4Bew
'' SIG '' mTc3hn/95O1LC9QuGNFv/l+RyyFXBe3iJvHOpMBwIkMa
'' SIG '' OXB5/2FbFLqqELV4zWE2GXHhxfgxTgHHww1pJNBdPpxR
'' SIG '' qIjQxmgkL24azZZyxxtRWI6mpgCu+/4ZeXzwKSMycBYc
'' SIG '' gVG9c5TUSh+s1a4HPrrBJ1lPJQ+8+v3rc6ytjZXAC/g8
'' SIG '' GhhIrxvatjLMNWzrFNG7iEciMYIEhjCCBIICAQEwgaYw
'' SIG '' gZExCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
'' SIG '' YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMg
'' SIG '' VHJ1c3QgTmV0d29yazFCMEAGA1UEAxM5U3ltYW50ZWMg
'' SIG '' Q2xhc3MgMyBFeHRlbmRlZCBWYWxpZGF0aW9uIENvZGUg
'' SIG '' U2lnbmluZyBDQSAtIEcyAhAeObM6nEaakCI61S77g784
'' SIG '' MAkGBSsOAwIaBQCggaYwGQYJKoZIhvcNAQkDMQwGCisG
'' SIG '' AQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQB
'' SIG '' gjcCARUwIwYJKoZIhvcNAQkEMRYEFHzstpXz5Fd5FiYQ
'' SIG '' xUEx16y1fviCMEYGCisGAQQBgjcCAQwxODA2oDSAMgBB
'' SIG '' AGQAbwBiAGUAIABJAGwAbAB1AHMAdAByAGEAdABvAHIA
'' SIG '' IABDAEMAIAAyADAAMQA1MA0GCSqGSIb3DQEBAQUABIIB
'' SIG '' ACH/K4O08xGPdzUwuqhijz1WjPiq6famBWxUZU0ltc/e
'' SIG '' 1iODEAQ+Wu5C4rwN2nw0IBsYWHbtuZRKry8cF42TGWQx
'' SIG '' jYV5MQnmgI8UNUmPLQGmNieQI+xivxXz6D+dfWv4mxPT
'' SIG '' aR+DbCt5alxnLk1yqACl/EXh5guUU62qaFzDRCit4otE
'' SIG '' mNwc55H9rMQGuMxeAl1awrr0Ohwywk8r6ioY549xTqoV
'' SIG '' nNJgMht1aVHAbqKXfi3z9zDLi/5598QGyPlAwolrQ7hN
'' SIG '' jXAMCAMbkLLgAjgQq7dLQtGFwR2jYAxs5UvvjEMFxruw
'' SIG '' A6w62TGz7BdiMx1WLAUaT4Nt4yc8ceyN8pKhggILMIIC
'' SIG '' BwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQswCQYD
'' SIG '' VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
'' SIG '' YXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUgU3Rh
'' SIG '' bXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+vzVu
'' SIG '' BNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkD
'' SIG '' MQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMTYw
'' SIG '' MTE0MjMxNDE2WjAjBgkqhkiG9w0BCQQxFgQUsDoWfzRu
'' SIG '' UpiZeHtozRNwV87FwdkwDQYJKoZIhvcNAQEBBQAEggEA
'' SIG '' jzb6pTXFNQ+woJyI/6uiAH3qEu9J7NKJzgBcN3GMGf9B
'' SIG '' JT0qtaxw06HF6xGOzjG9he1zmri2HaflaX4ECovq1l+o
'' SIG '' 9cPb2o+vx+vGZbrNEWK9BRHQaywEt3Sgqbzmsw3T1Vka
'' SIG '' S5BVeNNb8iCj3s3BEbXqZIBBoJmu8DX3BAQoiuDHTceB
'' SIG '' QjaW9zkev98u5k2OlpXZjY8WjtZ+qSBt6zqbYmy1GlZd
'' SIG '' SlW9nQPbv2NP6AtEHEWL1Csdsg9IkMYedkb7RI1sMR3t
'' SIG '' J6tpFvf16LeWfzFh4Tf+37geyWTdd28evC5GfeKgHAGn
'' SIG '' I3X/vSgtUO+Wy8l0N45x4CQkUtVkfmeadA==
'' SIG '' End signature block
